<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class SnippetsLeadingtextLeadingTextAnnotation extends \Google\Collection
{
  protected $collection_key = 'piece';
  protected $pieceDataType = 'array';
  public $piece;
  /**
   * @var string
   */
  public $pieceType;
  /**
   * @var int
   */
  public $type;

  /**
   * @param SnippetsLeadingtextLeadingTextAnnotationPiece[]
   */
  public function setPiece($piece)
  {
    $this->piece = $piece;
  }
  /**
   * @return SnippetsLeadingtextLeadingTextAnnotationPiece[]
   */
  public function getPiece()
  {
    return $this->piece;
  }
  /**
   * @param string
   */
  public function setPieceType($pieceType)
  {
    $this->pieceType = $pieceType;
  }
  /**
   * @return string
   */
  public function getPieceType()
  {
    return $this->pieceType;
  }
  /**
   * @param int
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return int
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SnippetsLeadingtextLeadingTextAnnotation::class, 'Google_Service_Contentwarehouse_SnippetsLeadingtextLeadingTextAnnotation');
